/*
 * Decompiled with CFR 0.152.
 */
package dev.satyrn.wolfarmor.client;

import dev.satyrn.wolfarmor.WolfArmorMod;
import dev.satyrn.wolfarmor.api.compatibility.Compatibility;
import dev.satyrn.wolfarmor.api.util.Items;
import dev.satyrn.wolfarmor.client.event.RenderEventHandler;
import dev.satyrn.wolfarmor.common.CommonProxy;
import dev.satyrn.wolfarmor.item.ItemWolfArmor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    @Override
    public void registerEntityRenderingHandlers() {
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        RenderLiving renderWolf = (RenderLiving)renderManager.field_78729_o.get(EntityWolf.class);
        LayerRenderer<?> armor = Compatibility.getArmorLayer(renderWolf);
        LayerRenderer<?> backpack = Compatibility.getBackpackLayer(renderWolf);
        if (armor != null) {
            renderWolf.func_177094_a(armor);
        } else {
            WolfArmorMod.getLogger().warning("Unable to initialize armor layer renderer!");
        }
        if (backpack != null) {
            renderWolf.func_177094_a(backpack);
        } else {
            WolfArmorMod.getLogger().warning("Unable to initialize backpack layer renderer!");
        }
    }

    @Override
    public void registerItemRenders(@Nonnull FMLInitializationEvent initializationEvent) {
        ClientProxy.registerItemModel(Items.LEATHER_WOLF_ARMOR);
        ClientProxy.registerItemModel(Items.CHAINMAIL_WOLF_ARMOR);
        ClientProxy.registerItemModel(Items.IRON_WOLF_ARMOR);
        ClientProxy.registerItemModel(Items.GOLD_WOLF_ARMOR);
        ClientProxy.registerItemModel(Items.DIAMOND_WOLF_ARMOR);
    }

    @Override
    public void registerItemColorHandlers(@Nonnull FMLInitializationEvent initializationEvent) {
        Minecraft.func_71410_x().getItemColors().func_186730_a(new IItemColor(){

            public int func_186726_a(@Nonnull ItemStack stack, int tintIndex) {
                return tintIndex > 0 ? -1 : ((ItemWolfArmor)stack.func_77973_b()).getColor(stack);
            }
        }, new Item[]{Items.LEATHER_WOLF_ARMOR});
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerItemModel(@Nullable Item item) {
        if (item != null && item.getRegistryName() != null) {
            ModelResourceLocation resource = new ModelResourceLocation(item.getRegistryName().toString(), "inventory");
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{item.getRegistryName()});
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, 0, resource);
        }
    }

    @Override
    public IThreadListener getThreadFromContext(MessageContext context) {
        return context.side.isClient() ? Minecraft.func_71410_x() : super.getThreadFromContext(context);
    }

    @Override
    public EntityPlayer getPlayerFromContext(MessageContext context) {
        return context.side.isClient() ? Minecraft.func_71410_x().field_71439_g : super.getPlayerFromContext(context);
    }

    @Override
    public Side getCurrentSide() {
        return Side.CLIENT;
    }

    @Override
    public void registerEventListeners() {
        super.registerEventListeners();
        MinecraftForge.EVENT_BUS.register((Object)new RenderEventHandler());
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        Compatibility.registerLayerProviders();
        Compatibility.postInit_Client(event);
    }

    @Override
    public void loadComplete(@Nonnull FMLLoadCompleteEvent loadCompleteEvent) {
        super.loadComplete(loadCompleteEvent);
        Compatibility.loadComplete_Client(loadCompleteEvent);
    }

    @Override
    public void preInit(@Nonnull FMLPreInitializationEvent preInitializationEvent) {
        super.preInit(preInitializationEvent);
        Compatibility.preInit_Client(preInitializationEvent);
    }

    @Override
    public void init(@Nonnull FMLInitializationEvent initializationEvent) {
        super.init(initializationEvent);
        Compatibility.init_Client(initializationEvent);
    }
}

